/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.utils;

import io.github.fabricators_of_create.porting_lib.util.ForgeI18n;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_3300;
import org.apache.commons.lang3.text.WordUtils;
import slimeknights.mantle.data.fabric.IdentifiableISafeManagerReloadListener;
import slimeknights.tconstruct.TConstruct;

public class DomainDisplayName {
    private static final Map<String, String> DISPLAY_NAME_LOOKUP = new HashMap<String, String>();
    private static final Pattern DASH_UNDERSCORE = Pattern.compile("[_-]");
    private static final IdentifiableISafeManagerReloadListener RELOAD_LISTENER = new IdentifiableISafeManagerReloadListener(TConstruct.getResource("domain_display_name")){

        @Override
        public void onReloadSafe(class_3300 resourceManager) {
            DISPLAY_NAME_LOOKUP.clear();
        }
    };

    private DomainDisplayName() {
    }

    private static String formatDomainName(String domain) {
        return WordUtils.capitalize((String)DASH_UNDERSCORE.matcher(domain).replaceAll(" "));
    }

    private static String nameForUncached(String domain) {
        String langKey = "domain." + domain + ".display_name";
        String translated = ForgeI18n.getPattern((String)langKey);
        if (!translated.equals(langKey)) {
            return translated;
        }
        return FabricLoader.getInstance().getModContainer(domain).map(container -> container.getMetadata().getName()).orElseGet(() -> DomainDisplayName.formatDomainName(domain));
    }

    public static String nameFor(String domain) {
        return DISPLAY_NAME_LOOKUP.computeIfAbsent(domain, DomainDisplayName::nameForUncached);
    }

    public static void addResourceListener(ResourceManagerHelper manager) {
        manager.registerReloadListener((IdentifiableResourceReloadListener)RELOAD_LISTENER);
    }
}

